﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;

namespace KursBeispiele
{
    public partial class Form1 : Form
    {
        Bitmap bmp;
        bool isDrawing;
        Point previous;

        //Variablen für Zeichnung
        Font useFont;
        Color useColor;
        Brush useBrush;
        Pen usePen;

        //Konstanten für Dateitypen
        const string PNG = ".png";
        const string BMP = ".bmp";
        const string GIF = ".gif";
        const string JPG = ".jpg";
        const string JPEG = ".jpeg";
        const string WMF = ".wmf";
        const string EMF = ".emf";
        const string TIF = ".tif";
        const string TIFF = ".tiff";

        public Form1()
        {
            InitializeComponent();

            //Filter für die Dialoge setzen
            StringBuilder sb = new StringBuilder();
            sb.Append("PNG|*").Append(PNG).Append("|BMP|*").Append(BMP).Append("|GIF|*").Append(GIF);
            sb.Append("|JPG|*").Append(JPG).Append(";*").Append(JPEG).Append("|WMF|*").Append(WMF);
            sb.Append("|EMF|*").Append(EMF).Append("|TIF|*").Append(TIF).Append(";*").Append(TIFF);
            openFileDialog1.Filter = saveFileDialog1.Filter = sb.ToString();

            //Standardwerte für Zeichenvariablen initialisieren
            useFont = Font;
            useColor = Color.Red;
            useBrush = new SolidBrush(useColor);
            usePen = new Pen(useBrush);

            //Kann aus Performancegründen sehr wichtig sein / werden:
            //DoubleBuffered = true;
            //SetStyle(ControlStyles.UserPaint | 
            //    ControlStyles.AllPaintingInWmPaint | 
            //    ControlStyles.OptimizedDoubleBuffer, true);
        }

        //Initialisieren unserer Variablen - oder löschen dieser (Bild resetten)
        private void Form1_Load(object sender, EventArgs e)
        {
            bmp = new Bitmap(pictureBox1.Width, pictureBox1.Height);
            pictureBox1.Image = bmp;
            pictureBox1.SizeMode = PictureBoxSizeMode.Normal;
        }

        //Koordinatensystem verdeutlichen
        private void button1_Click(object sender, EventArgs e)
        {
            using (Graphics g = Graphics.FromImage(bmp))
            {
                //Wieviele Boxen wollen wir ?
                int breite = 10;
                int hoehe = 10;
                //Höhe und Breite pro Box ausrechnen
                int wpb = bmp.Width / breite;
                int hpb = bmp.Height/ hoehe;

                //Alles komplett säubern
                //g.Clear(pictureBox1.BackColor);

                //Sauberere TextDarstellung
                g.TextRenderingHint = System.Drawing.Text.TextRenderingHint.AntiAliasGridFit;

                for (int i = 0; i < breite; i++)
                    for (int j = 0; j < hoehe; j++)
                        g.DrawString(((i + j) % 10).ToString(), useFont, useBrush,
                            new Point(wpb * i, hpb * j));

                //Ohne diesen Refresh kriegt die PictureBox nix von den Änderungen an bmp mit
                pictureBox1.Refresh();
            }
        }

        //Code zum Laden eines Bildes
        private void button2_Click(object sender, EventArgs e)
        {
            //Wenn der Dialog OK ist
            if (openFileDialog1.ShowDialog() == DialogResult.OK)
            {
                //Dann laden wir die Daten einfach
                bmp = Image.FromFile(openFileDialog1.FileName) as Bitmap;
                //Der AnzeigeModus sollte entsprechend angepasst sein
                pictureBox1.SizeMode = PictureBoxSizeMode.StretchImage;
                //Müssen die PictureBox neu hinzuweisen - Adresse hat sich geändert
                pictureBox1.Image = bmp;
            }
        }

        //Code zum Speichern eines Bildes
        private void button3_Click(object sender, EventArgs e)
        {
            //Wenn der Dialog OK ist
            if (saveFileDialog1.ShowDialog() == DialogResult.OK)
            {
                //Nutzen die statische Path Klasse um uns die Extension zu holen...
                //Vorsicht: Wir erhalten immer ".*****" zurück und nicht "*****" - daher müssen wir
                //den Punkt immer mit abfragen
                string extension = System.IO.Path.GetExtension(saveFileDialog1.FileName).ToLower();
                System.Drawing.Imaging.ImageFormat imgformat = null;

                //Jetzt wählen wir unser Bild aus
                switch (extension)
                {
                    case PNG:
                        imgformat = System.Drawing.Imaging.ImageFormat.Png;
                        break;
                    case BMP:
                        imgformat = System.Drawing.Imaging.ImageFormat.Bmp;
                        break;
                    case GIF:
                        imgformat = System.Drawing.Imaging.ImageFormat.Gif;
                        break;
                    case JPEG:
                    case JPG:
                        imgformat = System.Drawing.Imaging.ImageFormat.Jpeg;
                        break;
                    case TIF:
                    case TIFF:
                        imgformat = System.Drawing.Imaging.ImageFormat.Tiff;
                        break;
                    case EMF:
                        imgformat = System.Drawing.Imaging.ImageFormat.Emf;
                        break;
                    case WMF:
                        imgformat = System.Drawing.Imaging.ImageFormat.Wmf;
                        break;
                    default:
                        //Keins aus unserer Liste --> ungültig
                        MessageBox.Show("Format nicht erkannt!", "Ungültiges Format");
                        return;
                }

                bmp.Save(saveFileDialog1.FileName, imgformat);
            }
        }

        //Merken uns dass wir gerade MOUSEDOWN sind
        private void pictureBox1_MouseDown(object sender, MouseEventArgs e)
        {
            isDrawing = true;
            previous = e.Location;
            //Wenn wir zusätzlich noch was zeichnen wollen (Am Punkt wo wir die Mouse drücken)
            //dann kommentieren wir dieses return aus
            return;

            using (Graphics g = Graphics.FromImage(bmp))
            {
                //Um die Fähigkeiten des Brushes zu demonstrieren
                //g.FillEllipse(useBrush, new Rectangle(e.Location, new Size(200, 150)));

                g.DrawEllipse(usePen, new Rectangle(e.Location, new Size(50, 100)));
            }

            pictureBox1.Refresh();
        }

        //Heben die Variable auf
        private void pictureBox1_MouseUp(object sender, MouseEventArgs e)
        {
            isDrawing = false;
        }

        //Bewegen den Mauszeiger
        private void pictureBox1_MouseMove(object sender, MouseEventArgs e)
        {
            //Abfrage ob wir gerade MOUSEDOWN sind
            if (isDrawing)
            {
                //Sehr sauberes Arbeiten mit dem Graphics Objekt
                using (Graphics g = Graphics.FromImage(bmp))
                {
                    //Fortgeschrittene Technik: Kantenglättung
                    //g.SmoothingMode = System.Drawing.Drawing2D.SmoothingMode.AntiAlias;

                    //Faktoren für Streckung berechnen - fortgeschrittene Technik
                    //double wf = (double)bmp.Width / (double)pictureBox1.Width;
                    //double hf = (double)bmp.Height / (double)pictureBox1.Height;
                    //g.ScaleTransform((float)wf, (float)hf);
                    g.DrawLine(usePen, e.Location, previous);
                }

                //Ohne diesen Refresh kriegt die PictureBox nicht mit, dass sich das Bild geändert hat
                pictureBox1.Refresh();
                //Letzte Position speichern
                previous = e.Location;
            }
        }

        //Ändert den zu verwendenden Pen
        private void button5_Click(object sender, EventArgs e)
        {
            //Eigens gebauten Dialog aufmachen
            PenThickness pt = new PenThickness();
            pt.Thickness = usePen.Width;

            if (pt.ShowDialog() == DialogResult.OK)
                usePen = new Pen(useColor, pt.Thickness);
        }

        //Ändert den zu verwendenden Brush
        private void button6_Click(object sender, EventArgs e)
        {
            //Fancy new Brush: der LinearGradientBrush -> zeichnet Farbverlauf
            useBrush = new System.Drawing.Drawing2D.LinearGradientBrush(
                new Rectangle(0, 0, 100, 200), //Das Rechteck für die Berechnung des Farbverlaufs
                Color.Red, //1. Farbe des Verlaufs
                Color.Orange, //2. Farbe des Verlaufs
                System.Drawing.Drawing2D.LinearGradientMode.Vertical //hier könnten wir auch Winkel angeben
                );
            //Wichtig ist zu erkennen, dass das hier angegebene Rechteck (alternativ 2 Punkte)
            //nur die Grundlage der Berechnung des Farbverlaufs darstellt. Dieses Rechteck muss daher
            //nicht identisch zu dem Rechteck sein, wo der Brush verwendet wird. Im Zweifelsfall
            //wiederholt sich der Brush nur bzw. sieht komisch aus.
        }

        //Ändert die zu verwendende Farbe
        private void button7_Click(object sender, EventArgs e)
        {
            //Eingebauten ColorDialog aufrufen
            ColorDialog cd = new ColorDialog();
            cd.Color = useColor;

            if (cd.ShowDialog() == DialogResult.OK)
            {
                useColor = cd.Color;
                useBrush = new SolidBrush(useColor);
                usePen = new Pen(useColor, usePen.Width);
            }
        }

        //Ändert die zu verwendende Schriftart
        private void button8_Click(object sender, EventArgs e)
        {
            //Eingebauten FondDialog aufrufen
            FontDialog fd = new FontDialog();
            fd.Font = useFont;

            if (fd.ShowDialog() == DialogResult.OK)
                useFont = fd.Font;
        }
    }
}
